﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-06 (2009)</title>
		<script runat="server">

	static readonly int dataGraniczna = 18;	//XX.01.2010

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year;
            if (data.Month<7)
				rok --;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {				
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        [Priority(2)]
        public FromTo Okres {
			get { return FromTo.Year(rok); }
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
        //static bool debug = false;
        bool debug = false;
        [Priority(10)]
        [Caption("Liczby bez zaokrąglenia")]
        public bool Debug {
            get { return debug; }
            set {
                debug = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
        //przez listę a nie dla wszystkich
        //static bool wglisty = false;	
        bool wgListy = false;
        [Priority(20)]
        [Caption("Pracownicy wg listy")]
        public bool WgListy {
            get { return wgListy; }
            set {
                wgListy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        string zapis = "";
        [Priority(30)]
        [Caption("Zapis obliczeń")]
        public string Zapis {
            get { return zapis; }
            set {
                zapis = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }	
    		                        
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

    static string traceName = "";
    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { 
            srpars = value;
            traceName = srpars.Zapis;
        }
    }		
		        
    class WynagrodzeniaBase {
    
		protected readonly FromTo rok;
		
		protected WynagrodzeniaBase(FromTo rok) {
			this.rok = rok;
		}
		
		ICollection AktualnyOkres(Pracownik p) {
			ArrayList result = new ArrayList();
			
			//Elementy za okres sprawozawczy wypłacone do 18 stycznia następnego roku
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgPracownik[p];
            FromTo okres = EfektywnyOkres(p, rok);
			st = new SubTable(st, okres);
            FromTo ow1 = new FromTo(okres.From, okres.To + dataGraniczna);
			foreach (WypElement e in st)
				if (ow1.Contains(e.Data))
					result.Add(e);
					
			return result;
		}
		
		ICollection PoparzedniOkres(Pracownik p) {
			ArrayList result = new ArrayList();
            FromTo okres = EfektywnyOkres(p, rok);
            if (okres.From == Date.Empty || okres.From == Date.MaxValue || okres.From == Date.MinValue)
                return result;

            //Wypłaty wypłacone po 18 stycznia okresu sprawozdawczego za okresy poprzednie
			FromTo ow1 = new FromTo(new Date(okres.From + dataGraniczna), Date.MaxValue);
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgDaty[p];
			st = new SubTable(st, ow1);
			FromTo ow2 = new FromTo(Date.MinValue, okres.From-1);
			foreach (WypElement e in st)
				if (ow2.Contains(e.Okres.To))
					result.Add(e);
					
			return result;
		}
		
		protected IEnumerable Elementy(Pracownik p) {
			ArrayList result = new ArrayList();
			result.AddRange(AktualnyOkres(p));
			result.AddRange(PoparzedniOkres(p));
			return result;
		}
		
		protected IEnumerable ElementyRok(Pracownik p) {
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgPracownik[p];
            FromTo okres = EfektywnyOkres(p, rok);
            return new SubTable(st, okres);
		}
    }
    
    class ZatrudnienieWynagrodzenie: WynagrodzeniaBase {
    
		public decimal[] etaty = new decimal[12];
		public decimal brutto;
		public decimal[] eu = new decimal[12];
		public decimal bu;
		public decimal[] ez = new decimal[12];
		public decimal bz;
		public decimal zus;
		public decimal[] ei = new decimal[12];
		public decimal bi;
		
		readonly Periods miesiące;
		
		public ZatrudnienieWynagrodzenie(FromTo rok): base(rok) {
			miesiące = Periods.New(rok).BreakByMonth();
		}
		
		public void AddEtaty(PracHistoria ph) {            
			FromTo eo = EfektywnyOkres(ph);
			Periods ps = Periods.New(eo);
			KalkulatorPracy kp = new KalkulatorPracy(ph.Pracownik);
			foreach (INieobecnosc n in kp.Nieobecnosci(eo, true, Nieobecnosc.Przyczyna(PrzyczynaNieobecnosci.UrlopBezpłatny)))
				ps -= n.Okres;

			decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;            
			if (w==0m)
				w = 1m;
            Trace("Zapis ważny od: {0}, okres zatrudnienia (w ramach zapisu): {1}", ph.Aktualnosc.From, eo);
            Trace("Zatrunienie po uwględnieniu urlopów bezpłatnych: {0}", ps);
            Trace("Wymiar etatu: {0}", w);
            Trace("Okresy....");
            
			ps *= miesiące;
			foreach (FromTo ft in ps) {
                int n = NieobecnyDni(ph.Pracownik, ft);
                int m = ft.From.Month - 1;                
				int d = ft.Days;

                decimal e = (w * (d - n)) / miesiące[m].Days;

                Trace("* Okres: {0}, wymiar ({1}*{2}/{3})={4}", ft, w, (d - n), miesiące[m].Days, e);
                				
				switch (ph.Etat.RodzajZatrudnienia) {
					case RodzajZatrudnienia.NieDotyczy:
					case RodzajZatrudnienia.PracownikTymczasowy:
					case RodzajZatrudnienia.CzłonekRSP:
					case RodzajZatrudnienia.CzłonekSKR:
					case RodzajZatrudnienia.Student:
					case RodzajZatrudnienia.Absolwent:
                    case RodzajZatrudnienia.WięzieńLubAresztowany:
                        Trace("--> Pracownik ({0})", ph.Etat.RodzajZatrudnienia);
                        etaty[m] += e;
                        if (ph.GUS.PraceInterwencyjne) {
                            Trace("--> Prace interwencyjne");
                            ei[m] += e;
                        }
						break;
										
					case RodzajZatrudnienia.Uczeń1Klasy:
					case RodzajZatrudnienia.Uczeń2Klasy:
					case RodzajZatrudnienia.Uczeń3Klasy:
					case RodzajZatrudnienia.MłodocianyPrzyuczany:
                        Trace("--> Uczeń ({0})", ph.Etat.RodzajZatrudnienia);
                        eu[m] += e; break;
					
					case RodzajZatrudnienia.PracownikZaGranicą:
                    case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                        Trace("--> Pracownik za granicą ({0})", ph.Etat.RodzajZatrudnienia);
                        ez[m] += e; break;
				
					case RodzajZatrudnienia.Właściciel:
					case RodzajZatrudnienia.OsobaWspółpracująca:
					case RodzajZatrudnienia.Chałupnik:
                    case RodzajZatrudnienia.StanSpoczynku:
                    case RodzajZatrudnienia.UposażenieRodzinne:
                        //Agent
                        Trace("--> Nie uwzględniany ({0})", ph.Etat.RodzajZatrudnienia);
                        break;
									
					default:
						throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
				}
				
			}			
		}

        private int NieobecnyDni(Pracownik pracownik, FromTo okres) {
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);

            Periods on = Periods.Empty;
            foreach (INieobecnosc n in kp.Nieobecnosci(okres, true))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                    case PrzyczynaNieobecnosci.UrlopRodzicielski:
                        on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                        // urlop bezpłatny (art 174.1 kp)
                        // urlop bezpłatny (kod 350)
                        if (n.Definicja.Guid == new Guid("00000000-0006-0005-0010-000000000000") ||
                            n.Definicja.Guid == new Guid("00000000-0006-0005-0019-000000000000"))
                            on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                        Nieobecnosc no = (Nieobecnosc)((OkresNieobecności)n);
                        foreach (WypElement we in no.Elementy)
                            if (we.Definicja.Nazwa.Contains("Zas. chorobowy") ||
                                we.Definicja.Nazwa.Contains("Zas.chorob.") ||
                                we.Definicja.Nazwa.Contains("Zas.chorobowy"))
                                on += we.Okres * n.Okres;
                        break;
                }

            on = on.ToFlat();
            return on.Days;
        }
        
		public void AddBrutto(Pracownik p) {
            foreach (WypElement e in Elementy(p)) {
                Trace("* {0}/{1}/{2}, typ wypłaty: {3}, zasiłek: {4}, opodatkowany: {5}, wykazuj: {6}", 
                    e.Definicja.Nazwa, e.Okres, e.Data,
                    e.Wyplata.Typ, 
                    e.ZasiłekBudżet || e.ZasiłekZus, 
                    e.Definicja.Info.Opodatkowany, 
                    e.Definicja.GUS.WykazujNaDeklaracjach);
                if (e.Wyplata.Typ != TypWyplaty.Umowa
                    && !e.ZasiłekBudżet
                    && !e.ZasiłekZus
                    && e.Definicja.Info.Opodatkowany
                    && e.Definicja.GUS.WykazujNaDeklaracjach
                )
                    AddElement(e);
            }	
		}

		void AddElement(WypElement e) {
			PracHistoria ph = e.PracHistoria;
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
                case RodzajZatrudnienia.PracownikTymczasowy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
                case RodzajZatrudnienia.WięzieńLubAresztowany:
                    Trace("--> Pracownik ({0})", ph.Etat.RodzajZatrudnienia);
                    brutto += e.Wartosc;
                    if (ph.GUS.PraceInterwencyjne) {
                        Trace("--> Prace interwencyjne");
                        bi += e.Wartosc;
                    }
					zus += e.Podatki.KosztyZUS;
					break;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
                    Trace("--> Uczeń ({0})", ph.Etat.RodzajZatrudnienia);
                    bu += e.Wartosc;
					break;
				
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    Trace("--> Pracownik za granicą ({0})", ph.Etat.RodzajZatrudnienia);
                    bz += e.Wartosc;
					break;
			
				case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
				case RodzajZatrudnienia.Chałupnik:
                case RodzajZatrudnienia.StanSpoczynku:
                case RodzajZatrudnienia.UposażenieRodzinne:
                    //Agent
                    Trace("--> Nie uwzględniany ({0})", ph.Etat.RodzajZatrudnienia);
                    return;
			
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}
            Trace("--> brutto {0}, zus: {1}", e.Wartosc, e.Podatki.KosztyZUS);
		}
    }

            class Minimalne {

                public int min1;
                public int min2;
                readonly FromTo grudzień;
                readonly Context context;

                public Minimalne(Params pars) {
                    context = pars.Context;
                    this.grudzień = FromTo.Month(pars.Rok, 12);

                }

                public decimal Najniższe {
                    get {
                        return PlaceModule.GetInstance(context).Config.Wynagrodzenia.Najniższe[grudzień.From.FirstDayYear()-1];
                    }
                }

                public decimal Najniższe1 {
                    get {
                        return Najniższe - 0.01m;
                    }
                }

                public decimal Najniższe2 {
                    get {
                        return Soneta.Tools.Math.Round(Najniższe * 0.8m, 2);
                    }
                }
                
                public void AddOsoba(Pracownik p) {
                    PracHistoria ph = p[grudzień.To];
                    if (!EfektywnyOkres(p, ph.Etat.EfektywnyOkres).Contains(grudzień.To)) {
                        Trace("Pracownik niezatrudniony w dniu: {0}", grudzień.To);
                        return;
                    }

                    switch (ph.Etat.RodzajZatrudnienia) {
                        case RodzajZatrudnienia.NieDotyczy:
                        case RodzajZatrudnienia.PracownikTymczasowy:
                        case RodzajZatrudnienia.CzłonekRSP:
                        case RodzajZatrudnienia.CzłonekSKR:
                        case RodzajZatrudnienia.Student:
                        case RodzajZatrudnienia.Absolwent:
                        case RodzajZatrudnienia.WięzieńLubAresztowany:
                            Trace("--> Wchodzi ({0})", ph.Etat.RodzajZatrudnienia);
                            break;

                        case RodzajZatrudnienia.Uczeń1Klasy:
                        case RodzajZatrudnienia.Uczeń2Klasy:
                        case RodzajZatrudnienia.Uczeń3Klasy:
                        case RodzajZatrudnienia.MłodocianyPrzyuczany:
                        case RodzajZatrudnienia.PracownikZaGranicą:
                        case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                        case RodzajZatrudnienia.Właściciel:
                        case RodzajZatrudnienia.OsobaWspółpracująca:
                        case RodzajZatrudnienia.Chałupnik:
                        case RodzajZatrudnienia.StanSpoczynku:
                        case RodzajZatrudnienia.UposażenieRodzinne:
                            //Agent
                            Trace("--> Nie uwzględniany ({0})", ph.Etat.RodzajZatrudnienia);
                            return;

                        default:
                            throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
                    }

                    decimal we = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
                    if (we == 0m)
                        we = 1;

                    Trace("Wymiar etatu: {0}", we);

                    PlaceModule płace = PlaceModule.GetInstance(p);
                    SubTable st = płace.WypElementy.WgPracownik[p];
                    FromTo okres = EfektywnyOkres(p, grudzień);
                    st = new SubTable(st, okres);
                    decimal w = 0m;
                    foreach (WypElement e in st) {
                        Trace("* {0}/{1}/{2}, uwzględniany w podstawie: {3}, wykazywany na deklaracjach: {4}",
                            e.Definicja.Nazwa, e.Okres, e.Data,
                            e.Definicja.MinimalneWynagrodzenie, 
                            e.Definicja.GUS.WykazujNaDeklaracjach);
                        if (e.Definicja.MinimalneWynagrodzenie
                            && e.Definicja.GUS.WykazujNaDeklaracjach
                        ) 
                        {
                            decimal x = e.Wartosc / we;
                            Trace("--> Wartość: {0}, po przeliczeniu: {1}", e.Wartosc, x);
                            w += x;
                        }
                    }

                    w = Soneta.Tools.Math.RoundCy(w);

                    Trace("Po przeliczeniu na pełny wymiar: {0}", w);

                    if (w <= Najniższe) {
                        min1++;
                        if (Najniższe1 >= w && w >= Najniższe2)
                            min2++;
                    }
                }
            }
    
    class SkładnikiWynagrodzeń: WynagrodzeniaBase {
    
		public decimal brutto;
        public decimal bruttoObcy;
        public decimal nadliczbowe;
        public decimal chałupnicy;
        public decimal zysk;
        public decimal zyskObcy;
        public decimal budżet;
        public decimal budżetObcy;
        public decimal umowy;
        public decimal honoraria;
        public decimal honorariaNieObcy;
        public decimal prowizje;
		
		public SkładnikiWynagrodzeń(FromTo rok): base(rok) {
		}

        public void AddBrutto(Pracownik p, bool pracownikObcy) {
            decimal odchyłki = 0;
            Time czasNadgodzin = Time.Zero;
            Time czasOdchyłek = Time.Zero;

            foreach (WypElement e in Elementy(p)) {
                Trace("* {0}/{1}/{2}, kategoria GUS: {3}", e.Definicja.Nazwa, e.Okres, e.Data, 
                    e.Definicja.GUS.Kategoria);
                
                switch (e.Definicja.GUS.Kategoria) {
                    case KategoriaWynagrodzeniaGUS.NieWykazujNaDeklaracjach:
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku:
                        Trace("--> WypłataUdziałWZysku: {0}", e.Wartosc);
                        zysk += e.Wartosc;
                        if (pracownikObcy)
                            zyskObcy += e.Wartosc;
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.DodatkoweWynagrodzenieRoczne:
                        Trace("--> DodatkoweWynagrodzenieRoczne: {0}", e.Wartosc);
                        budżet += e.Wartosc; 
                        if (pracownikObcy)
                            budżetObcy += e.Wartosc;
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.Honorarium:
                        Trace("--> Honorarium: {0}", e.Wartosc);
                        honoraria += e.Wartosc; 
                        if (!pracownikObcy)
                            honorariaNieObcy += e.Wartosc;
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.WynagrodzenieAkwizycyjnoProwizyjne:
                        Trace("--> WynagrodzenieAkwizycyjnoProwizyjne: {0}", e.Wartosc);
                        prowizje += e.Wartosc; 
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.WynagrodzenieOsobowe:
                        Trace("--> WynagrodzenieOsobowe: {0}", e.Wartosc);
                        brutto += e.Wartosc;
                        if (pracownikObcy)
                            bruttoObcy += e.Wartosc;
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.WynagrodzenieNadliczbowe:
                        Trace("--> WynagrodzenieNadliczbowe: {0}", e.Wartosc);
                        czasNadgodzin += e.Czas;
                        nadliczbowe += e.Wartosc;
                        brutto += e.Wartosc;
                        if (pracownikObcy)
                            bruttoObcy += e.Wartosc;
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.WynagrodzeniePracaNakładcza:
                        Trace("--> WynagrodzeniePracaNakładcza: {0}", e.Wartosc);
                        chałupnicy += e.Wartosc;
                        brutto += e.Wartosc;
                        if (pracownikObcy)
                            bruttoObcy += e.Wartosc;
                        break;
                        
                    case KategoriaWynagrodzeniaGUS.WynagrodzenieUmowa:
                        Trace("--> WynagrodzenieUmowa: {0}", e.Wartosc);
                        umowy += e.Wartosc;
                        break;    
                        
                    case KategoriaWynagrodzeniaGUS.WgDefinicjiElementu:
                        Trace("--> Opodatkowany: {0}, zasiłek: {1}", e.Definicja.Info.Opodatkowany, e.ZasiłekZus || e.ZasiłekBudżet);
                        if (e.Definicja.Info.Opodatkowany && !e.ZasiłekZus && !e.ZasiłekBudżet)
                            if (e.Wyplata.Typ == TypWyplaty.Umowa) {
                                if (Honorarium(e)) {
                                    Trace("--> Honorarium: {0}", e.Wartosc);
                                    honoraria += e.Wartosc;
                                    if (!pracownikObcy)
                                        honorariaNieObcy += e.Wartosc;
                                }
                                else if (UmowaZlecenie(e)) {
                                    Trace("--> UmowaZlecenie: {0}", e.Wartosc);
                                    umowy += e.Wartosc;
                                }
                            }
                            else if (WchodziEtat(e)) {//Bez kontroli okresu zatrudnienia
                                Trace("--> Etat: {0}", e.Wartosc);
                                brutto += e.Wartosc;
                                if (pracownikObcy)
                                    bruttoObcy += e.Wartosc;
                                PracHistoria ph = e.PracHistoria;
                                if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Chałupnik) {
                                    Trace("--> Chałupnicy: {0}", e.Wartosc);
                                    chałupnicy += e.Wartosc;
                                }
                                //Wliczamy dopłaty do nadgodzin oraz odchyłki+ minu odchyłki- (min 0)
                                switch (e.RodzajZrodla) {
                                    case RodzajŹródłaWypłaty.NadgodzinyI:
                                    case RodzajŹródłaWypłaty.NadgodzinyII:
                                    case RodzajŹródłaWypłaty.NadgodzinyŚw:
                                        czasNadgodzin += e.Czas;
                                        nadliczbowe += e.Wartosc;
                                        Trace("--> Nadgodziny ({0}): {1}/{2}", e.RodzajZrodla, e.Wartosc, e.Czas);
                                        break;
                                    default:
                                        foreach (WypSkladnik s in e.Skladniki)
                                            switch (s.Rodzaj) {
                                                case RodzajSkładnikaWypłaty.OdchyłkaPlus:
                                                case RodzajSkładnikaWypłaty.OdchyłkaMinus:
                                                    czasOdchyłek += s.Czas;
                                                    odchyłki += s.Wartosc;
                                                    Trace("--> Odchyłka ({0}): {1}/{2}", s.Rodzaj, e.Wartosc, e.Czas);
                                                    break;
                                            }
                                        break;
                                }
                            }
                        break;
                    default:
                        throw new Exception("Nieoczekiwana wartość pola e.Definicja.GUS.Kategoria: " + e.Definicja.GUS.Kategoria);
                }
            }

            if (odchyłki > 0) {
                if (Time.Zero < czasNadgodzin && czasNadgodzin < czasOdchyłek)
                    odchyłki = Soneta.Tools.Math.RoundCy(odchyłki * (decimal)(czasNadgodzin / czasOdchyłek));

                nadliczbowe += odchyłki;
            }
        }
		
		bool WchodziEtat(WypElement e) {
			PracHistoria ph = e.PracHistoria;
			
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
                case RodzajZatrudnienia.PracownikTymczasowy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
				case RodzajZatrudnienia.Chałupnik:
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                case RodzajZatrudnienia.WięzieńLubAresztowany:
                    Trace("--> Pracownik: {0}", ph.Etat.RodzajZatrudnienia);
                    return true;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
				case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
                case RodzajZatrudnienia.StanSpoczynku:
                case RodzajZatrudnienia.UposażenieRodzinne:
                    //Agent
                    Trace("--> Nie uwzględniany: {0}", ph.Etat.RodzajZatrudnienia);
                    return false;
			
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}
		}		
		
		bool Honorarium(WypElement e) {
			PozycjaPIT pit = e.Definicja.Deklaracje.PozycjaPIT;
			return pit!=null && pit.PIT8B==70;
		}
		
		bool UmowaZlecenie(WypElement e) {
			switch (e.Definicja.Deklaracje.Umowa) {
				case TypUmowyCywilnoPrawnej.UmowaODzieło:
				case TypUmowyCywilnoPrawnej.UmowaZlecenia:
					return true;
			}
			return false;
		}
    }
    
    class CzasPracy: WynagrodzeniaBase{
    
		public Time ogółem = Time.Zero;
		public Time nadlicz = Time.Zero;
		public Time nieobec = Time.Zero;
        public Time chorobowe = Time.Zero;
		
		public CzasPracy(FromTo rok): base(rok) {
		}

        private Time NieobecnyGodz(Pracownik pracownik) {
            Dictionary<DefinicjaNieobecnosci, Periods> nieob1 = new Dictionary<DefinicjaNieobecnosci, Periods>();
            Dictionary<DefinicjaNieobecnosci, Periods> nieob2 = new Dictionary<DefinicjaNieobecnosci, Periods>();
            Time czas = Time.Zero;
            Periods ps;

            KalkulatorPracy kp = new KalkulatorPracy(pracownik);
            foreach (INieobecnosc n in kp.Nieobecnosci(rok, true)) {
                bool nb1 = false, nb2 = false;
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                        nb1 = true;
                        break;
                    case PrzyczynaNieobecnosci.UsprawiedliwionaNiepłatna:
                        // urlop bezpłatny (art 174.1 kp)
                        if (n.Definicja.Guid == new Guid("00000000-0006-0005-0010-000000000000"))
                            nb1 = true;
                        break;
                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                    case PrzyczynaNieobecnosci.UrlopOjcowski:
                    case PrzyczynaNieobecnosci.UrlopRodzicielski:
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                        nb2 = true;
                        break;
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                        Nieobecnosc no = (Nieobecnosc)((OkresNieobecności)n);
                        foreach (WypElement we in no.Elementy)
                            if (we.Definicja.Nazwa.Contains("Zas. chorobowy") ||
                                we.Definicja.Nazwa.Contains("Zas.chorob.") ||
                                we.Definicja.Nazwa.Contains("Zas.chorobowy")) {
                                if (!nieob2.TryGetValue(n.Definicja, out ps))
                                    nieob2.Add(n.Definicja, Periods.Empty);
                                nieob2[n.Definicja] += we.Okres * n.Okres;
                            }
                            else
                                foreach (INieobecnosc nb in kp.Nieobecnosci(we.Okres * n.Okres, true))
                                    czas += ((OkresNieobecności)nb).Norma().Czas;
                        break;
                }
                if (nb1) {
                    if (!nieob1.TryGetValue(n.Definicja, out ps))
                        nieob1.Add(n.Definicja, Periods.Empty);
                    nieob1[n.Definicja] += n.Okres;
                }
                else if (nb2) {
                    if (!nieob2.TryGetValue(n.Definicja, out ps))
                        nieob2.Add(n.Definicja, Periods.Empty);
                    nieob2[n.Definicja] += n.Okres;
                }
                else if (n.Definicja.Przyczyna != PrzyczynaNieobecnosci.ZwolnienieChorobowe)
                    czas += ((OkresNieobecności)n).Norma().Czas;
            }

            foreach (DefinicjaNieobecnosci dn in nieob1.Keys)
                foreach (FromTo ft in nieob1[dn].ToFlat())
                    if (ft.Days <= 90) // do 3 miesięcy
                        foreach (INieobecnosc n in kp.Nieobecnosci(ft, true))
                            czas += n.Definicja == dn ? ((OkresNieobecności)n).Norma().Czas : Time.Zero;
            
            foreach (DefinicjaNieobecnosci dn in nieob2.Keys)
                foreach (FromTo ft in nieob2[dn].ToFlat()) {
                    Periods psn = ft.ToPeriods().BreakByMonth();
                    foreach (FromTo ftn in psn) {
                        int dniN = 0;
                        Time czasN = Time.Zero;
                        foreach (INieobecnosc n in kp.Nieobecnosci(ftn, true))
                            if (n.Definicja == dn) {
                                CzasDni cd = ((OkresNieobecności)n).Norma();
                                dniN += cd.Dni;
                                czasN += cd.Czas;
                            }
                        if (dniN <= 14) // do 14 dni roboczych w miesiącu
                            czas += czasN;
                    }
                }
                                    
            return czas;
        }
        
		public void AddCzas(Pracownik p) {
            Soneta.Kalend._Pracownik.CzasPracyBaseWorker worker;
            worker = new Soneta.Kalend._Pracownik.CzasPracyEtatWorker();
            worker.Pracownik = p;
            worker.Okres = rok;
            ogółem += worker.Praca.Czas;
            nadlicz += worker.Nadgodziny.Razem;
            nieobec += NieobecnyGodz(p);
            Set<FromTo> okresy = new Set<FromTo>();
            foreach (WypElement e in Elementy(p)) {
                Time czas = Time.Zero;
                if (e.KodRSA != null && e.KodRSA.WynagrodzenieChorobowe)
                    czas = e.Pracownik.Czasy.Norma(e.Okres).Czas;
                else {
                    Nieobecnosc n = e.BazaZrodla as Nieobecnosc;
                    if (n != null && n.Definicja.Typ == TypNieobecnosci.UsprawiedliwionaPłatna)
                        czas = e.Czas >= Time.Zero ? e.Czas : -e.Czas;
                }
                if (czas == Time.Zero)
                    continue;
                if (e.Dni < 0) {
                    chorobowe -= czas;
                    okresy[e.Okres] = false;
                }
                else {
                    bool b = false;
                    okresy.TryGetValue(e.Okres, out b);
                    if (!b) {
                        chorobowe += czas;
                        okresy[e.Okres] = true;
                    }
                }
            }
		}
    }

    class ZatrZwolBase {

        protected static void Inc(bool kobieta, ref int mężczyźni, ref int kobiety) {
            if (kobieta)
                kobiety++;
            else
                mężczyźni++;
        }

        protected static bool NieobecnyCałyRok(Pracownik pracownik, FromTo rokex) {
            Periods on = Periods.Empty;

            KalkulatorPracy kp = new KalkulatorPracy(pracownik);
            foreach (INieobecnosc n in kp.Nieobecnosci(rokex, false))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    case PrzyczynaNieobecnosci.SłużbaWojskowa:
                        on += n.Okres;
                        break;
                }

            return (Periods.New(rokex) - on) == Periods.Empty;                        
        }
        
        protected static bool Nieobecny(Pracownik pracownik, int rok, out PrzyczynaNieobecnosci przyczyna) {
            przyczyna = PrzyczynaNieobecnosci.NieDotyczy;
            
            Date data = new Date(rok, 12, 31);
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);
            FromTo okres = new FromTo((new YearMonth(data) - 2).FirstDay, (new YearMonth(data) + 3).LastDay);
            Periods on = Periods.Empty;
            Periods on2 = Periods.Empty;
            foreach (INieobecnosc n in kp.Nieobecnosci(okres, false)) {
                if (n.Okres.Contains(data))
                    przyczyna = n.Definicja.Przyczyna;
                
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                        //Na DG-1 każdy wychowawczy
                        on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                        if (n.Zwolnienie.Przyczyna != PrzyczynaZwolnienia.UrlopRehabilitacyjnyCiąża)
                            on2 += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.SłużbaWojskowa:
                        //Nie ma na DG-1
                        on2 += n.Okres;
                        break;
                }
            }

            //Nieobecności 'każdy dzień'
            if (on2[data] != FromTo.Empty)
                return true;

            on = on.ToFlat();
            okres = on[data];
            if (okres == FromTo.Empty)
                return false;
            StazPracy sp = new StazPracy(okres, pracownik).Normalizuj();
            return sp.Lata > 0 || sp.Miesiace > 2;
        }
    }

	class MiejscePracy: IComparable {
	
		public int CompareTo(object obj) {
			MiejscePracy mp = (MiejscePracy)obj;
			int i = gmina.CompareTo(mp.gmina);
            if (i == 0)
                i = miasto.CompareTo(mp.miasto);
            if (i == 0)
                i = rodzaj.CompareTo(mp.rodzaj);
            return i;
		}

        public override int GetHashCode() {
            return gmina.GetHashCode() ^ miasto.GetHashCode() ^ rodzaj.GetHashCode();
        }

        public readonly string gmina;
        public readonly string rodzaj;
        public readonly bool miasto;
		public int razem, kobiety;
		
		public MiejscePracy(string gmina, string rodzaj, bool miasto) {
            this.gmina = gmina;
            this.rodzaj = rodzaj;
            this.miasto = miasto;
		}
		
		public void Add(PracHistoria ph) {
			if (ph.Plec==PłećOsoby.Kobieta)
				kobiety++;
			razem++;
		}
	}

    class Pracujący31XII : ZatrZwolBase {

        public int pracujący, pracującyK,
        główne, główneK,
        pełnozatrudnieni, pełnozatrudnieniK,
        pełnozatrudnieniOkres, pełnozatrudnieniOkresK,
        niepełnozatrudnieni, niepełnozatrudnieniK,
        niepełnozatrudnieniOkres, niepełnozatrudnieniOkresK,
        wlswsp, wlswspK,
        nakładcza, nakładczaK,
        rsp, rspK,
        wnocnej, wnocnejK,
        niepełnosprawni, niepełnosprawniK,
        cudzoziemcy, cudzoziemcyK,
        emrent, emrentK;

        readonly int rok;
        readonly Date data;

        public Hashtable miejsca = new Hashtable();
        MiejscePracy razem = new MiejscePracy("", "", false);

        public Pracujący31XII(int rok) {
            this.rok = rok;
            data = new Date(rok, 12, 31);
            miejsca.Add("", razem);
        }

        public void AddPracownik(Pracownik p) {
            AddPracownik(p[data]);
        }

        void AddPracownik(PracHistoria ph) {
            bool kobieta = ph.Plec == PłećOsoby.Kobieta;
            Trace("--> Efektywny okres zatrudnienia: {0}, zawiera 31 XII: {1}", EfektywnyOkres(ph), EfektywnyOkres(ph).Contains(data));
            if (EfektywnyOkres(ph.Pracownik, ph.Etat.EfektywnyOkres).Contains(data)) {
                switch (ph.Etat.RodzajZatrudnienia) {
                    case RodzajZatrudnienia.NieDotyczy:
                    case RodzajZatrudnienia.PracownikTymczasowy:
                    case RodzajZatrudnienia.CzłonekRSP:
                    case RodzajZatrudnienia.CzłonekSKR:
                    case RodzajZatrudnienia.Student:
                    case RodzajZatrudnienia.Absolwent:
                    case RodzajZatrudnienia.Właściciel:
                    case RodzajZatrudnienia.OsobaWspółpracująca:
                    case RodzajZatrudnienia.Chałupnik:
                    case RodzajZatrudnienia.PracownikZaGranicą:
                    case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    case RodzajZatrudnienia.WięzieńLubAresztowany:
                        //Agent
                        Trace("--> Wykazywany: {0}", ph.Etat.RodzajZatrudnienia);
                        break;

                    case RodzajZatrudnienia.Uczeń1Klasy:
                    case RodzajZatrudnienia.Uczeń2Klasy:
                    case RodzajZatrudnienia.Uczeń3Klasy:
                    case RodzajZatrudnienia.MłodocianyPrzyuczany:
                    case RodzajZatrudnienia.StanSpoczynku:
                    case RodzajZatrudnienia.UposażenieRodzinne:
                        Trace("--> Nie wykazywany: {0}", ph.Etat.RodzajZatrudnienia);
                        return;

                    default:
                        throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
                }
                PrzyczynaNieobecnosci przyczyna;
                if (Nieobecny(ph.Pracownik, rok, out przyczyna))
                    Trace("--> Pracownik nieobecny");
                else {
                    Inc(kobieta, ref pracujący, ref pracującyK);
                    if (ph.GUS.GlowneMiejscePracy) {
                        Trace("--> Główne miejsce pracy");
                        Inc(kobieta, ref główne, ref główneK);
                        Wydzial wdz = !ph.Etat.PracownikZaGranicą ? ph.Etat.Wydzial : ph.Module.Wydzialy.Firma;
                        string gmina = wdz.GUS.Gmina;
                        string rodzaj = wdz.GUS.Dzialalnosc;
                        bool miasto = wdz.GUS.MiastoWies == MiastoWieś.Miasto;
                        if (gmina == "")
                            gmina = "&nbsp;";
                        if (rodzaj == "")
                            rodzaj = "&nbsp;";
                        string key = gmina.ToUpper() + "|" + miasto + "|" + rodzaj.ToUpper();
                        MiejscePracy msc = (MiejscePracy)miejsca[key];
                        if (msc == null)
                            miejsca.Add(key, msc = new MiejscePracy(gmina, rodzaj, miasto));
                        msc.Add(ph);
                        razem.Add(ph);

                        switch (ph.Etat.RodzajZatrudnienia) {
                            case RodzajZatrudnienia.Właściciel:
                            case RodzajZatrudnienia.OsobaWspółpracująca:
                                Trace("--> Właściciel lub osoba współpracująca.");
                                Inc(kobieta, ref wlswsp, ref wlswspK);
                                break;

                            case RodzajZatrudnienia.CzłonekRSP:
                            case RodzajZatrudnienia.CzłonekSKR:
                                Trace("--> Członek RSP/SKR");
                                Inc(kobieta, ref rsp, ref rspK);
                                break;

                            case RodzajZatrudnienia.Chałupnik:
                                Trace("--> Chałupnik");
                                Inc(kobieta, ref nakładcza, ref nakładczaK);
                                break;

                            //Agenci
                            default:
                                if (ph.Etat.Zaszeregowanie.Wymiar == 1) {
                                    Trace("--> Pełny wymiar czasu pracy");
                                    Inc(kobieta, ref pełnozatrudnieni, ref pełnozatrudnieniK);
                                }
                                else {
                                    Trace("--> Niepełny wymiar czasu pracy");
                                    Inc(kobieta, ref niepełnozatrudnieni, ref niepełnozatrudnieniK);
                                }

                                bool okres = ph.Etat.TypUmowy != TypUmowyOPrace.NaCzasNieokreślony;
                                if (okres) {
                                    Trace("--> Zatrudnienie na czas określony");
                                    if (ph.Etat.Zaszeregowanie.Wymiar == 1)
                                        Inc(kobieta, ref pełnozatrudnieniOkres, ref pełnozatrudnieniOkresK);
                                    else
                                        Inc(kobieta, ref niepełnozatrudnieniOkres, ref niepełnozatrudnieniOkresK);
                                }
                                break;
                        }

                        if (ph.GUS.PracaWNocy) {
                            Trace("--> Praca w nocy");
                            Inc(kobieta, ref wnocnej, ref wnocnejK);
                        }

                        if (ph.PFRON.Stopien != StNiepełnosprawności.Brak ||
                            ph.StopienNiepelnosp.Stopien != StNiepełnosprawności.Brak) {
                            bool niep = false;
                            Date d31XII = new Date(rok, 12, 31);
                            if (ph.PFRON.Stopien != StNiepełnosprawności.Brak &&
                                ph.PFRON.Okres.Contains(d31XII)) {
                                Trace("--> Niepełnosprawny ({0})", ph.PFRON.Stopien);
                                niep = true;
                            }
                            else if (ph.StopienNiepelnosp.Stopien != StNiepełnosprawności.Brak &&
                                ph.StopienNiepelnosp.Okres.Contains(d31XII)) {
                                Trace("--> Niepełnosprawny ({0})", ph.StopienNiepelnosp.Stopien);
                                niep = true;
                            }
                            if (niep)
                                Inc(kobieta, ref niepełnosprawni, ref niepełnosprawniK);
                        }

                        if (ph.Obywatelstwo.Nazwa.ToLower() != Obywatelstwo.Polskie.ToLower()) {
                            Trace("--> Cudzoziemiec ({0})", ph.Obywatelstwo.Nazwa);
                            Inc(kobieta, ref cudzoziemcy, ref cudzoziemcyK);
                        }

                        if (ph.PrawoEmRent.Kod != KodPrawaEmRent.Brak) {
                            Trace("--> Posiada prawo do emerytury lub renty ({0})", ph.PrawoEmRent.Kod);
                            Inc(kobieta, ref emrent, ref emrentK);
                        }
                    }
                }
            }
        }
    }
	
	class PrzyczynaRU: IComparable {
	
		public int CompareTo(object obj) {
			PrzyczynaRU pru = (PrzyczynaRU)obj;
			return nazwa.CompareTo(pru.nazwa);
		}
	
		public readonly string nazwa;
		public int razem, kobiety;
		
		public PrzyczynaRU(string nazwa) {
			this.nazwa = nazwa;
		}
		
		public void Add(PracHistoria ph) {
			if (ph.Plec==PłećOsoby.Kobieta)
				kobiety++;
			razem++;
		}
	}
	
    class ZatrudnieniZwolnieni: ZatrZwolBase {
		readonly FromTo rok;
		readonly FromTo rokex;
		
		public int poprzednio, poprzednioK,
		przyjęci, przyjęciK,
		pierwsza, pierwszaK,
		wyższa, wyższaK,
		policealna, policealnaK,
		liceum, liceumK,
		zasadnicza, zasadniczaK,
		zurlopu, zurlopuK,
        pracowałPonadMies, pracowałPonadMiesK,
        pracowałDoMies, pracowałDoMiesK,
        pozostali, pozostaliK, 
		zwolnieni, zwolnieniK,
		naurlop, naurlopK,
        nabezpłatny, nabezpłatnyK,
        narehab, narehabK,
        dowojska, dowojskaK,
        niepełnyNaPełny, niepełnyNaPełnyK,
        pełnyNaNiepełny, pełnyNaNiepełnyK;
		
		public Hashtable przyczyny = new Hashtable();
		
		public ZatrudnieniZwolnieni(FromTo rok) {
			this.rok = rok;
			this.rokex = new FromTo(rok.From-1, rok.To+1);
		}

        static bool PE(Pracownik pracownik, Date data) {
            return pracownik[data].Etat.Wymiar == Fraction.One;
        }

        public void AddPracownik(Pracownik pracownik) {
            bool kobieta = pracownik.Last.Plec == PłećOsoby.Kobieta;

            bool naPełny = false;
            bool naNiepełny = false;
            bool first = true;
            bool pełny = false;
            bool niepełny = false;

            foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(EfektywnyOkres(pracownik, rokex)))
                if (ph.GUS.GlowneMiejscePracy /*&& !ph.GUS.SezonowyDorywczy*/) {
                    if (first)
                        first = false;
                    else {
                        if (pełny && ph.Etat.Wymiar < Fraction.One)
                            naNiepełny = true;

                        if (niepełny && ph.Etat.Wymiar >= Fraction.One)
                            naPełny = true;
                    }
                    pełny = ph.Etat.Wymiar >= Fraction.One;
                    niepełny = ph.Etat.Wymiar < Fraction.One;
                }

            if (naPełny)
                Inc(kobieta, ref niepełnyNaPełny, ref niepełnyNaPełnyK);

            if (naNiepełny)
                Inc(kobieta, ref pełnyNaNiepełny, ref pełnyNaNiepełnyK);

            Periods oz = Periods.Empty;
            foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(EfektywnyOkres(pracownik, rokex)))
                if (ph.GUS.GlowneMiejscePracy /*&& !ph.GUS.SezonowyDorywczy*/ /*&& ph.Etat.Zaszeregowanie.Wymiar==1    TID: 9971*/) {
                    switch (ph.Etat.RodzajZatrudnienia) {
                        case RodzajZatrudnienia.NieDotyczy:
                        case RodzajZatrudnienia.PracownikTymczasowy:
                        case RodzajZatrudnienia.CzłonekRSP:
                        case RodzajZatrudnienia.CzłonekSKR:
                        case RodzajZatrudnienia.Student:
                        case RodzajZatrudnienia.Absolwent:
                        case RodzajZatrudnienia.Chałupnik:
                        case RodzajZatrudnienia.PracownikZaGranicą:
                        case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                        case RodzajZatrudnienia.WięzieńLubAresztowany:
                            //Agent
                            break;

                        case RodzajZatrudnienia.Właściciel:
                        case RodzajZatrudnienia.OsobaWspółpracująca:
                        case RodzajZatrudnienia.Uczeń1Klasy:
                        case RodzajZatrudnienia.Uczeń2Klasy:
                        case RodzajZatrudnienia.Uczeń3Klasy:
                        case RodzajZatrudnienia.MłodocianyPrzyuczany:
                        case RodzajZatrudnienia.StanSpoczynku:
                        case RodzajZatrudnienia.UposażenieRodzinne:
                            continue;

                        default:
                            throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
                    }

                    oz += EfektywnyOkres(ph);
                }
            oz = (oz * rokex).ToFlat();
            //W ogóle nie pracował
            if (oz == Periods.Empty)
                return;

            PrzyczynaNieobecnosci beginP = PrzyczynaNieobecnosci.NieDotyczy;
            bool begin = oz.Contains(rokex.From);
            bool beginN = begin && Nieobecny(pracownik, rokex.From.Year, out beginP);
            PrzyczynaNieobecnosci endP = PrzyczynaNieobecnosci.NieDotyczy;
            bool end = !oz.Contains(rokex.To);
            bool endN = !end && Nieobecny(pracownik, rokex.To.Year - 1, out endP);

            //Pracownik niew był neobecny przez cały rok
            if (!beginN || !endN || !NieobecnyCałyRok(pracownik, rok)) {
                //TID: 9971, Pracownika wykazujemy tylko pod warunkiem, że w pierwszym/ostatnim dniu pracy był na pełnym etacie
                if (PE(pracownik, oz.From))     //TID: 9971
                    if (begin && !beginN)
                        Inc(kobieta, ref poprzednio, ref poprzednioK);
                    else if (oz * rok != FromTo.Empty) {
                        Inc(kobieta, ref przyjęci, ref przyjęciK);
                        if (beginN)
                            switch (beginP) {
                                case PrzyczynaNieobecnosci.UrlopWychowawczy:
                                case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                                    Inc(kobieta, ref zurlopu, ref zurlopuK);
                                    break;
                                default:
                                    Inc(kobieta, ref pozostali, ref pozostaliK);
                                    break;
                            }
                        else {
                            PracHistoria ph = pracownik[oz.From];

                            if (ph.GUS.PierwszaPraca) {
                                Inc(kobieta, ref pierwsza, ref pierwszaK);

                                switch (ph.GUS.PopMiejsceZatrudnienia) {
                                    case PopMiejsceZatrudnienia.AbsolwentSzkołyWyższej:
                                        Inc(kobieta, ref wyższa, ref wyższaK); break;

                                    case PopMiejsceZatrudnienia.AbsolwentSzkołyPolicealnej:
                                    case PopMiejsceZatrudnienia.AbsolwentSzkołyŚredniejZawodowej:
                                        Inc(kobieta, ref policealna, ref policealnaK); break;

                                    case PopMiejsceZatrudnienia.AbsolwentLiceumOgólnokształcącego:
                                        Inc(kobieta, ref liceum, ref liceumK); break;

                                    case PopMiejsceZatrudnienia.AbsolwentSzkołyZasadniczej:
                                        Inc(kobieta, ref zasadnicza, ref zasadniczaK); break;
                                }
                            }
                            else
                                switch (PoprzednioPracował(pracownik, oz.From - 1)) {
                                    case JakPoprzednioPracował.DoMiesiąca:
                                        Inc(kobieta, ref pracowałDoMies, ref pracowałDoMiesK); break;
                                    case JakPoprzednioPracował.PrzerwaPonadMiesiąc:
                                        Inc(kobieta, ref pracowałPonadMies, ref pracowałPonadMiesK); break;
                                    default:
                                        Inc(kobieta, ref pozostali, ref pozostaliK); break;
                                }
                        }
                    }

                if (PE(pracownik, oz.To) && oz * rok != FromTo.Empty)       //TID: 9971
                    if (endN || end) {
                        Inc(kobieta, ref zwolnieni, ref zwolnieniK);
                        if (endN)
                            switch (endP) {
                                case PrzyczynaNieobecnosci.UrlopWychowawczy:
                                case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                                    Inc(kobieta, ref naurlop, ref naurlopK);
                                    break;
                                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                                    Inc(kobieta, ref nabezpłatny, ref nabezpłatnyK);
                                    break;
                                case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                                    Inc(kobieta, ref narehab, ref narehabK);
                                    break;
                                case PrzyczynaNieobecnosci.SłużbaWojskowa:
                                    Inc(kobieta, ref dowojska, ref dowojskaK);
                                    break;
                            }
                        else {
                            PracHistoria ph = pracownik[oz.To];
                            string s = ph.Etat.PrzyczynaRozwUmowy;
                            if (s == "")
                                s = "Nieokreślona przyczyna rozwiązania umowy";

                            PrzyczynaRU pru = (PrzyczynaRU)przyczyny[s.ToUpper()];
                            if (pru == null)
                                przyczyny.Add(s.ToUpper(), pru = new PrzyczynaRU(s));
                            pru.Add(ph);
                        }
                    }
            }
        }

        enum JakPoprzednioPracował {
            NiePracował, DoMiesiąca, PrzerwaPonadMiesiąc
        }
        
        JakPoprzednioPracował PoprzednioPracował(Pracownik pracownik, Date data) {
            Periods oz = Periods.Empty;
            foreach (HistoriaZatrudnieniaBase hz in pracownik.HistoriaZatrudnienia)
                if (hz.Typ == TypHistoriiZatrudnienia.Zatrudnienie && hz.Okres != FromTo.Empty)
                    oz += hz.Okres;
            foreach (PracHistoria ph in pracownik.Historia)
                oz += EfektywnyOkres(pracownik, ph.Etat.EfektywnyOkres);

            oz *= new FromTo(Date.MinValue, data);
            oz = oz.ToFlat();
            
            bool any = false;
			foreach (FromTo okres in oz) {
                    if (okres.Contains(data))
                        return JakPoprzednioPracował.DoMiesiąca;
                    else if (okres.To <= data) {
                        StazPracy sp = new StazPracy(new FromTo(okres.To - 1, data), pracownik).Normalizuj();
                        if (sp.Lata == 0 && sp.Miesiace == 0)
                            return JakPoprzednioPracował.DoMiesiąca;
                    }
                    any = true;
                }
            if (any)
                return JakPoprzednioPracował.PrzerwaPonadMiesiąc;
            return JakPoprzednioPracował.NiePracował;
        }
    }

    static Log trace;
		    
    void dc_ContextLoad(Object sender, EventArgs e) {
        trace = null;
        if (traceName != "")
            trace = new Log(traceName, true);
        
        ReportHeader["ROK"] = pars.Rok.ToString();
        FromTo rok = pars.Okres;

        KadryModule kadry = KadryModule.GetInstance(dc);

        ZatrudnienieWynagrodzenie zw = new ZatrudnienieWynagrodzenie(rok);
        Minimalne min = new Minimalne(pars);
        SkładnikiWynagrodzeń sw = new SkładnikiWynagrodzeń(rok);
        CzasPracy cp = new CzasPracy(rok);
        Pracujący31XII z1231 = new Pracujący31XII(rok.To.Year);
        ZatrudnieniZwolnieni zatrzw = new ZatrudnieniZwolnieni(rok);

        najniższe.EditValue = min.Najniższe;
        najniższe1.EditValue = min.Najniższe1;
        najniższe2.EditValue = min.Najniższe2;
        
        Log log = new Log();
        int m;
        int l = 0;
        
        IEnumerable pracownicy;
        if (srpars.WgListy) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
            m = lista.Count;
        }
        else {
            Soneta.Business.View view = kadry.Pracownicy.CreateView();
            view.ForceAllRows();
            m = view.Count;
            pracownicy = view;
        }

        foreach (Pracownik p in pracownicy) {
            Trace(p);
            log.WriteLine(new Percent(++l, m));
            log.WriteLine(p);

            bool pracownikObcy = PracownikObcy(p, pars.Okres);
            Trace("  Pracownik zewnętrzny: " + pracownikObcy);
            Trace("-- W przeliczeniu na pełny wymiar czasu pracy -------");
            foreach (PracHistoria ph in p.Historia.GetIntersectedRows(EfektywnyOkres(p, rok)))
                zw.AddEtaty(ph);
            Trace("-- Wynagrodzenie ------------------------------------");
            if (!pracownikObcy)
                zw.AddBrutto(p);
            Trace("-- Minimalne ----------------------------------------");
            min.AddOsoba(p);
            Trace("-- Składniki wynagrodzenia --------------------------");
            sw.AddBrutto(p, pracownikObcy);
            //Trace("-- Czas pracy ---------------------------------------");
            cp.AddCzas(p);
            Trace("-- Zatrudnieni w dniu 31 XII ------------------------");
            z1231.AddPracownik(p);
            //Trace("-- Przyjęci/zwolnieni -------------------------------");
            zatrzw.AddPracownik(p);
            Trace("-----------------------------------------------------");
        }

        etatyOgółem.EditValue = Etaty(zw.etaty);
        etatyUczniowie.EditValue = Etaty(zw.eu);
        etatyZagranica.EditValue = Etaty(zw.ez);
        etatyInterwencyjni.EditValue = Etaty(zw.ei);

        bruttoOgółem.EditValue = Tys(zw.brutto);
        bruttoUczniowie.EditValue = Tys(zw.bu);
        bruttoZagranica.EditValue = Tys(zw.bz);
        zus.EditValue = Tys(zw.zus);
        bruttoInterwencyjni.EditValue = Tys(zw.bi);

        osobyMin1.EditValue = min.min1;
        osobyMin2.EditValue = min.min2;

        osobowe.EditValue = Tys(sw.brutto);
        nadliczbowe.EditValue = Tys(sw.nadliczbowe);
        chałupnicy.EditValue = Tys(sw.chałupnicy);
        bruttoObcy.EditValue = Tys(sw.bruttoObcy);
        zysk.EditValue = Tys(sw.zysk);
        zyskObcy.EditValue = Tys(sw.zyskObcy);
        budżet.EditValue = Tys(sw.budżet);
        budżetObcy.EditValue = Tys(sw.budżetObcy);
        umowy.EditValue = Tys(sw.umowy);
        honoraria.EditValue = Tys(sw.honoraria);
        honorariaNieObcy.EditValue = Tys(sw.honorariaNieObcy);
        prowizje.EditValue = Tys(sw.prowizje);

        ogółem.EditValue = Czas(cp.ogółem);
        nadlicz.EditValue = Czas(cp.nadlicz);
        nieobec.EditValue = Czas(cp.nieobec);
        wynchor.EditValue = Czas(cp.chorobowe);
        //TID: 9879
        //płatne.EditValue = Czas(cp.płatne);
        //urlopy.EditValue = Czas(cp.urlopy);
        //choroby.EditValue = Czas(cp.choroby);

        pracujący.EditValue = z1231.pracujący + z1231.pracującyK;
        pracującyK.EditValue = z1231.pracującyK;
        główne.EditValue = z1231.główne + z1231.główneK;
        główneK.EditValue = z1231.główneK;
        pełnozatrudnieni.EditValue = z1231.pełnozatrudnieni + z1231.pełnozatrudnieniK;
        pełnozatrudnieniK.EditValue = z1231.pełnozatrudnieniK;
        pełnozatrudnieniOkres.EditValue = z1231.pełnozatrudnieniOkres + z1231.pełnozatrudnieniOkresK;
        pełnozatrudnieniOkresK.EditValue = z1231.pełnozatrudnieniOkresK;
        niepełnozatrudnieni.EditValue = z1231.niepełnozatrudnieni + z1231.niepełnozatrudnieniK;
        niepełnozatrudnieniK.EditValue = z1231.niepełnozatrudnieniK;
        niepełnozatrudnieniOkres.EditValue = z1231.niepełnozatrudnieniOkres + z1231.niepełnozatrudnieniOkresK;
        niepełnozatrudnieniOkresK.EditValue = z1231.niepełnozatrudnieniOkresK;
        wlswsp.EditValue = z1231.wlswsp + z1231.wlswspK;
        wlswspK.EditValue = z1231.wlswspK;
        nakładcza.EditValue = z1231.nakładcza + z1231.nakładczaK;
        nakładczaK.EditValue = z1231.nakładczaK;
        rsp.EditValue = z1231.rsp + z1231.rspK;
        rspK.EditValue = z1231.rspK;
        wnocnej.EditValue = z1231.wnocnej + z1231.wnocnejK;
        wnocnejK.EditValue = z1231.wnocnejK;
        niepełnosprawni.EditValue = z1231.niepełnosprawni + z1231.niepełnosprawniK;
        niepełnosprawniK.EditValue = z1231.niepełnosprawniK;
        cudzoziemcy.EditValue = z1231.cudzoziemcy + z1231.cudzoziemcyK;
        cudzoziemcyK.EditValue = z1231.cudzoziemcyK;
        emrent.EditValue = z1231.emrent + z1231.emrentK;
        emrentK.EditValue = z1231.emrentK;

        poprzednio.EditValue = zatrzw.poprzednio + zatrzw.poprzednioK;
        poprzednioK.EditValue = zatrzw.poprzednioK;
        przyjęci.EditValue = zatrzw.przyjęci + zatrzw.przyjęciK;
        przyjęciK.EditValue = zatrzw.przyjęciK;
        pierwsza.EditValue = zatrzw.pierwsza + zatrzw.pierwszaK;
        pierwszaK.EditValue = zatrzw.pierwszaK;
        wyższa.EditValue = zatrzw.wyższa + zatrzw.wyższaK;
        wyższaK.EditValue = zatrzw.wyższaK;
        policealna.EditValue = zatrzw.policealna + zatrzw.policealnaK;
        policealnaK.EditValue = zatrzw.policealnaK;
        liceum.EditValue = zatrzw.liceum + zatrzw.liceumK;
        liceumK.EditValue = zatrzw.liceumK;
        zasadnicza.EditValue = zatrzw.zasadnicza + zatrzw.zasadniczaK;
        zasadniczaK.EditValue = zatrzw.zasadniczaK;
        pracował.EditValue = zatrzw.pracowałDoMies + zatrzw.pracowałDoMiesK + zatrzw.pracowałPonadMies + zatrzw.pracowałPonadMiesK;
        pracowałK.EditValue = zatrzw.pracowałDoMiesK + zatrzw.pracowałPonadMiesK;
        pracowałDoMies.EditValue = zatrzw.pracowałDoMies + zatrzw.pracowałDoMiesK;
        pracowałDoMiesK.EditValue = zatrzw.pracowałDoMiesK;
        zurlopu.EditValue = zatrzw.zurlopu + zatrzw.zurlopuK;
        zurlopuK.EditValue = zatrzw.zurlopuK;
        pozostali.EditValue = zatrzw.pozostali + zatrzw.pozostaliK;
        pozostaliK.EditValue = zatrzw.pozostaliK;
        zwolnieni.EditValue = zatrzw.zwolnieni + zatrzw.zwolnieniK;
        zwolnieniK.EditValue = zatrzw.zwolnieniK;
        naurlop.EditValue = zatrzw.naurlop + zatrzw.naurlopK;
        naurlopK.EditValue = zatrzw.naurlopK;
        nabezpłatny.EditValue = zatrzw.nabezpłatny + zatrzw.nabezpłatnyK;
        nabezpłatnyK.EditValue = zatrzw.nabezpłatnyK;
        narehab.EditValue = zatrzw.narehab + zatrzw.narehabK;
        narehabK.EditValue = zatrzw.narehabK;
        dowojska.EditValue = zatrzw.dowojska + zatrzw.dowojskaK;
        dowojskaK.EditValue = zatrzw.dowojskaK;
        niepełnyNaPełny.EditValue = zatrzw.niepełnyNaPełny + zatrzw.niepełnyNaPełnyK;
        niepełnyNaPełnyK.EditValue = zatrzw.niepełnyNaPełnyK;
        pełnyNaNiepełny.EditValue = zatrzw.pełnyNaNiepełny + zatrzw.pełnyNaNiepełnyK;
        pełnyNaNiepełnyK.EditValue = zatrzw.pełnyNaNiepełnyK;
        
        if (zatrzw.przyczyny.Count > 0) {
            string ss = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"1\" style=\"border-collapse: collapse; font-family: Verdana; font-size: 11px;\">";

            ArrayList lista = new ArrayList(zatrzw.przyczyny.Values);
            lista.Sort();
            foreach (PrzyczynaRU pz in lista) {
                ss += "<TR>";
                ss += string.Format("<TD width=\"50%\">{0}</TD>", pz.nazwa);
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", pz.razem);
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", pz.kobiety);
                ss += "</TR>";
            }

            ss += "</TABLE>";

            przyczyny.EditValue = ss;
        }
        else
            przyczyny.EditValue = "&nbsp;";

        if (z1231.miejsca.Count > 0) {
            string ss = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"1\" style=\"border-collapse: collapse; font-family: Verdana; font-size: 11px;\">";
            ss += "<TR>";
            ss += "<TD width=\"45%\" align=\"center\">Nazwy miast, gmin i województw<br>Opis rodzaju działalności</TD>";
            ss += "<TD width=\"05%\" align=\"center\"><strong>1</strong>-miasto, <strong>2</strong>-wieś</TD>";
            ss += "<TD width=\"25%\" align=\"center\">Ogółem</TD>";
            ss += "<TD width=\"25%\" align=\"center\">W tym kobiety</TD>";
            ss += "</TR>";

            ArrayList lista = new ArrayList(z1231.miejsca.Values);
            lista.Sort();
            foreach (MiejscePracy mp in lista) {
                ss += "<TR>";
                if (mp.gmina == "") {
                    ss += "<TD width=\"45%\"><STRONG>Ogółem</STRONG> (dział 4 wiersz 02)</TD>";
                    ss += "<TD width=\"5%\">&nbsp;</TD>";
                }
                else {
                    ss += string.Format("<TD width=\"45%\">{0}<br>{1}</TD>", mp.gmina, mp.rodzaj);
                    ss += string.Format("<TD width=\"5%\" align=\"center\">{0}</TD>", mp.miasto ? 1 : 2);
                }
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", mp.razem);
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", mp.kobiety);
                ss += "</TR>";
            }

            ss += "</TABLE>";

            miejsca.EditValue = ss;
        }
        else
            miejsca.EditValue = "&nbsp;";
    }

    bool PracownikObcy(Pracownik p, FromTo okres) {
        foreach (PracHistoria ph in p.Historia.GetIntersectedRows(EfektywnyOkres(p, okres)))
            if (ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.PracownikZaGranicą && EfektywnyOkres(ph) * okres != FromTo.Empty)
                return false;
        return true;
    }
    		        
    public decimal Etaty(decimal[] etaty) {
		decimal razem = 0m;
		foreach (decimal d in etaty)
			razem += d;
		razem /= etaty.Length;
		if (srpars.Debug)
			return Soneta.Tools.Math.Round(razem, 2);
		return Soneta.Tools.Math.Round(razem, 1);
    }

    public decimal Tys(decimal value) {
		if (srpars.Debug)
			return value;
		return Soneta.Tools.Math.Round(value/1000m, 1);
    }
    
    public object Czas(Time t) {
		if (srpars.Debug)
			return t;
		return Soneta.Tools.Math.Round(t.TotalHours/1000.0, 1);
    }

    static FromTo EfektywnyOkres(Pracownik p, FromTo okres) {
        foreach (PracHistoria ph in p.Historia.GetIntersectedRows(new FromTo(okres.From, Date.MaxValue)))
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty) {
                Date dt = okres.To != Date.Empty ? okres.To : Date.MaxValue;
                if (ph.Etat.DataPrzejeciaPracownika <= dt)
                    okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, dt);
                break;
            }
        return okres;
    }

    static FromTo EfektywnyOkres(PracHistoria ph) {
        FromTo okres = ph.Etat.EfektywnyOkres;
        if (ph.Etat.DataPrzejeciaPracownika != Date.Empty)
            okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, Date.MaxValue);
        return okres;
    }
    
    static void Msg(params object[] values) {
        StringBuilder sb = new StringBuilder();
        bool first = true;
        foreach (object value in values) {
            if (first)
                first = false;
            else
                sb.Append("\n");
            sb.Append(value == null ? "(null)" : value.ToString());
        }
            
    }

    static void Trace(object value) {
        if (trace != null)
            trace.WriteLine(value == null ? "(null)" : value.ToString());
    }

    static void Trace(string format, params object[] values) {
        if (trace != null)
            trace.WriteLine(string.Format(format, values));
    }		        
		        
		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	    </HEAD>
	<body>
		<form method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Z-06 Sprawozdanie o pracujących, wynagrodzeniach i czasie pracy|</strong>Rok: <strong>%ROK%" runat="server"></eb:reportheader>
			<p>
			<font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 1. Zatrudnienie i wynagrodzenia</font>
				<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3"><STRONG>Wyszczególnienie</STRONG></TD>
						<TD align="center" width="20%">Przeciętna liczba<BR>
								zatrudnionych<br />
                            <b>(z jednym znakiem po przecinku)</b></TD>
						<TD align="center">Wynagrodzenie brutto w tyś zł.<BR> (z jednym 
                            znakiem po przecinku)</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2">Ogółem</TD>
						<TD align="center" width="5%">1</TD>
						<TD style="HEIGHT: 23px" align="right"><ea:datalabel id="etatyOgółem" runat="server"></ea:datalabel></TD>
						<TD style="HEIGHT: 23px" align="right"><ea:datalabel id="bruttoOgółem" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Osoby (uczniowie) zatrudnione na podstawie umowy o pracę 
								w celu przygotowania zawodowego</TD>
						<TD align="center">2</TD>
						<TD align="right"><ea:datalabel id="etatyUczniowie" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoUczniowie" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Osoby zatrudnione poza granicami kraju</TD>
						<TD align="center">3</TD>
						<TD align="right"><ea:datalabel id="etatyZagranica" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoZagranica" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%" rowspan="2">Z wiersza 1</TD>
						<TD>składki na ubezpieczenie emerytalne, rentowe i chorobowe opłacone 
								przez ubezpieczonych</TD>
						<TD align="center">4</TD>
						<TD align="right">&nbsp;</TD>
						<TD align="right"><ea:datalabel id="zus" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>pracownicy zatrudnieni przy pracach interwencyjnych i robotach 
								publicznych</TD>
						<TD align="center">5</TD>
						<TD align="right"><ea:datalabel id="etatyInterwencyjni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoInterwencyjni" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</p>
			<P>
				<TABLE id="Table2" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD width="45%"><STRONG>Liczba pracowników</STRONG> wg stanu w dniu 
								31 XII otrzymujących w grudniu <STRONG>wynagrodzenie nieprzekraczające minimalnego 
									wynagrodzenia</STRONG> zgodnie z rozporządzeniem Rady Ministrów z dnia 
                            11 września 2013 r. w sprawie wysokości minimalnego wynagrodzenia za pracę w 2014 r. (Dz. U. poz. 1074) 
 <STRONG>w osobach</STRONG></TD>
						<TD align="center" width="5%">6</TD>
						<TD>
							<TABLE id="Table3" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                                style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
								<TR>
									<TD align="center" width="33%">
                                        <ea:datalabel id="najniższe" runat="server" bold="false"></ea:datalabel>
                                        zł i mniej
									</TD>
									<TD colSpan="2">
										<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                                            style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
											<TR>
												<TD align="center" colSpan="2">w tym</TD>
											</TR>
											<TR>
												<TD align="center" width="50%">
                                                    <ea:datalabel id="najniższe1" runat="server" bold="false"></ea:datalabel>
                                                    -
                                                    <ea:datalabel id="najniższe2" runat="server" bold="false"></ea:datalabel>
                                                    zł.
												</TD>
											</TR>
										</TABLE>
									</TD>
								</TR>
								<TR>
									<TD align="right"><ea:datalabel id="osobyMin1" runat="server"></ea:datalabel></TD>
									<TD align="right" width="33%"><ea:datalabel id="osobyMin2" runat="server"></ea:datalabel></TD>
								</TR>
							</TABLE>
						</TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak1" runat="server" Required="False"></ea:pagebreak>
			<P>
			    <font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 2. 
                Składniki wynagrodzeń - brutto </font>
			    <font style="font-family: Verdana; font-size: 11px;"><i>(z jednym znakiem po przecinku)</i></font>
				<TABLE id="Table5" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="70%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center">W tyś. zł</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenie osobowe</TD>
						<TD align="center" width="5%">1</TD>
						<TD align="right"><ea:datalabel id="osobowe" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%" rowspan="3">Z wiersza 1</TD>
						<TD>za pracę w godzinach nadliczbowych</TD>
						<TD align="center">2</TD>
						<TD align="right"><ea:datalabel id="nadliczbowe" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>osób wykonujących pracę nakładczą</TD>
						<TD align="center">3</TD>
						<TD align="right"><ea:datalabel id="chałupnicy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>pracowników obcych</TD>
						<TD align="center">4</TD>
						<TD align="right"><ea:datalabel id="bruttoObcy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wypłaty z tytułu udziału w zysku lub nadwyżce bilansowej 
								w spółdzielniach</TD>
						<TD align="center">5</TD>
						<TD align="right"><ea:datalabel id="zysk" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp;&nbsp; w tym dla pracowników obcych&nbsp;</TD>
						<TD align="center">6</TD>
						<TD align="right"><ea:datalabel id="zyskObcy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Dodatkowe wynagrodzenia roczne dla pracowników jednostek 
								sfery budżetowej</TD>
						<TD align="center">7</TD>
						<TD align="right"><ea:datalabel id="budżet" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp;&nbsp; w tym dla pracowników obcych&nbsp;</TD>
						<TD align="center">8</TD>
						<TD align="right"><ea:datalabel id="budżetObcy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenia z tytułu umowy-zlecenia lub umowy o dzieło<BR>
								<EM>(wynagrodzenia bezosobowe)</EM></TD>
						<TD align="center">9</TD>
						<TD align="right"><ea:datalabel id="umowy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Honoraria</TD>
						<TD align="center">10</TD>
						<TD align="right"><ea:datalabel id="honoraria" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp;&nbsp; w tym honoraria wynikające z umowy o pracę (bez 
                            pracowników obcych)&nbsp;</TD>
						<TD align="center">11</TD>
						<TD align="right"><ea:datalabel id="honorariaNieObcy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenia agencyjno-prowizyjne</TD>
						<TD align="center">12</TD>
						<TD align="right"><ea:datalabel id="prowizje" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<p><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 2a. 
                Zaległości w wypłacie wynagrodzeń - stan w dniu 31 XII</font></p>
			<ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 3. 
                Czas pracy </font>
				<i><font style="font-family: Verdana; font-size: 11px;">(w tyś. godzin z jednym 
                znakiem po przecinku)</font></i>
				<TABLE id="Table6" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="2">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="2">0</TD>
						<TD align="center">1</TD>
					</TR>
					<TR>
						<TD>Czas faktycznie przepracowany ogółem</TD>
						<TD align="center" width="5%">1</TD>
						<TD align="right"><ea:datalabel id="ogółem" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>w tym w godzinach nadliczbowych</TD>
						<TD align="center">2</TD>
						<TD align="right"><ea:datalabel id="nadlicz" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Czas nieprzepracowany ogółem</TD>
						<TD align="center">3</TD>
						<TD align="right"><ea:datalabel id="nieobec" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>w tym opłacony przez zakład pracy</TD>
						<TD align="center">4</TD>
						<TD align="right"><ea:datalabel id="wynchor" runat="server"></ea:datalabel></TD>
					</TR>
					</TABLE>
			</P>
			<ea:pagebreak id="PageBreak3" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 4. Pracujący - stan w dniu 31 XII</font>
				<TABLE id="Table7" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem</TD>
						<TD align="center">W tym kobiety</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2">Pracujący ogółem</TD>
						<TD align="center" width="5%">01</TD>
						<TD align="right"><ea:datalabel id="pracujący" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pracującyK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Pracujący, dla których jednostka 
									sprawozdawcza jest <STRONG>głównym</STRONG> miejscem pracy (w. 
									03+05+07 do 10) <b>SUMA!</b></TD>
						<TD align="center">02</TD>
						<TD align="right"><ea:datalabel id="główne" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="główneK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Pełnozatrudnieni</TD>
						<TD align="center">03</TD>
						<TD align="right"><ea:datalabel id="pełnozatrudnieni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pełnozatrudnieniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp;&nbsp; w tym zatrudnieni na umowy okresowe</TD>
						<TD align="center">04</TD>
						<TD align="right"><b><ea:datalabel id="pełnozatrudnieniOkres" runat="server"></ea:datalabel></b></TD>
						<TD align="right"><ea:datalabel id="pełnozatrudnieniOkresK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Niepełnozatrudnieni</TD>
						<TD align="center">05</TD>
						<TD align="right"><ea:datalabel id="niepełnozatrudnieni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="niepełnozatrudnieniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp;&nbsp; w tym zatrudnieni na umowy okresowe</TD>
						<TD align="center">06</TD>
						<TD align="right"><ea:datalabel id="niepełnozatrudnieniOkres" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="niepełnozatrudnieniOkresK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Właściciele, współwłaściciele 
									łącznie z pomagającymi członkami ich rodzin</TD>
						<TD align="center">07</TD>
						<TD align="right"><ea:datalabel id="wlswsp" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="wlswspK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Osoby wykonujące pracę nakładczą</TD>
						<TD align="center">08</TD>
						<TD align="right"><ea:datalabel id="nakładcza" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nakładczaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Agenci (bez sołtysów)</TD>
						<TD align="center">09</TD>
						<TD align="right">&nbsp;</TD>
						<TD align="right">&nbsp;</TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Członkowie spółdzielni produkcji rolniczej</TD>
						<TD align="center">10</TD>
						<TD align="right"><ea:datalabel id="rsp" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rspK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%" rowspan="5">Z wiersza 02</TD>
						<TD>pracujący w porze nocnej</TD>
						<TD align="center">11</TD>
						<TD align="right"><ea:datalabel id="wnocnej" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="wnocnejK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>niepełnosprawni</TD>
						<TD align="center">12</TD>
						<TD align="right"><ea:datalabel id="niepełnosprawni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="niepełnosprawniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>cudzoziemcy</TD>
						<TD align="center">13</TD>
						<TD align="right"><ea:datalabel id="cudzoziemcy" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="cudzoziemcyK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>emeryci i renciści</TD>
						<TD align="center">14</TD>
						<TD align="right"><ea:datalabel id="emrent" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="emrentK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>pracownicy zatrudnieni w formie telepracy</TD>
						<TD align="center">15</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD align="left" width="10%" colspan="5"><b>Dodatkowe informacje</b></TD>
					</TR>
					<TR>
						<TD width="10%" colspan="2">Pracownicy udostępnieni (zatrudnieni) 
                            przez agencję pracy tymczasowej stan w dniu 31 XII</TD>
						<TD align="center">16</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD width="10%" colspan="2">Pracownicy zatrudnieni na kontraktach, 
                            których umowa nie ma charakteru umowy o pracę stan w dniu 31 XII</TD>
						<TD align="center">17</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD width="10%" colspan="2">Osoby, z którymi w okresie od 1 I do 31 
                            XII roku sprawozdawczego zawarto <strong>umowę zlecenia</strong>, a które nie 
                            są nigdzie zatrudnione na podstawie stosunku pracy</TD>
						<TD align="center">18</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD width="10%" colspan="2">w tym emeryci i renciści</TD>
						<TD align="center">19</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD width="10%" colspan="2">Osoby, z którymi w okresie od 1 I do 31 
                            XII roku sprawozdawczego zawarto <strong>umowę o dzieło</strong>, a które nie 
                            są nigdzie zatrudnione na podstawie stosunku pracy</TD>
						<TD align="center">20</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD width="10%" colspan="2">w tym emeryci i renciści</TD>
						<TD align="center">21</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak4" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 5. Przyjęcia do pracy i zwolnienia z pracy pracowników 
					pełnozatrudnionych w głównym miejscu pracy</font>
				<TABLE id="Table8" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem</TD>
						<TD align="center">W tym kobiety</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2"><STRONG>Pełnozatrudnieni</STRONG><em> </em>w dniu 31 XII <strong>2013 r. (poprzedni rok sprawozdawczy)</strong></TD>
						<TD align="center" width="5%">01</TD>
						<TD align="right"><ea:datalabel id="poprzednio" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="poprzednioK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2"><STRONG>Przyjęci</STRONG> <EM>(pełnozatrudnieni)</EM> do 
								pracy <STRONG>w okresie</STRONG> od&nbsp;1 I do 31 XII <STRONG>roku sprawozdawczego</STRONG>
								<EM>(suma wierszy 03+08+10+11)</EM></TD>
						<TD align="center">02</TD>
						<TD align="right"><ea:datalabel id="przyjęci" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="przyjęciK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby podejmujące pracę po raz pierwszy</TD>
						<TD align="center">03</TD>
						<TD align="right"><ea:datalabel id="pierwsza" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pierwszaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%" rowspan="4">&nbsp;w tym z wiersza 03 absolwenci</TD>
						<TD align="left">szkół wyższych</TD>
						<TD align="center">04</TD>
						<TD align="right"><ea:datalabel id="wyższa" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="wyższaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>szkół policealnych i średnich zawodowych</TD>
						<TD align="center">05</TD>
						<TD align="right"><ea:datalabel id="policealna" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="policealnaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>liceów ogólnokształcących</TD>
						<TD align="center">06</TD>
						<TD align="right"><ea:datalabel id="liceum" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="liceumK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>szkół zasadniczych</TD>
						<TD align="center">07</TD>
						<TD align="right"><ea:datalabel id="zasadnicza" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="zasadniczaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Osoby poprzednio pracujące</TD>
						<TD align="center">08</TD>
						<TD align="right"><ea:datalabel id="pracował" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pracowałK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; w tym osoby, u których przerwa w pracy nie była dłuższa 
                            niż 1 miesiąc</TD>
						<TD align="center">09</TD>
						<TD align="right"><ea:datalabel id="pracowałDoMies" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pracowałDoMiesK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby, które powróciły z urlopów wychowawczych</TD>
						<TD align="center">10</TD>
						<TD align="right"><ea:datalabel id="zurlopu" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="zurlopuK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; pozostali przyjęci do pracy</TD>
						<TD align="center">11</TD>
						<TD align="right"><ea:datalabel id="pozostali" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pozostaliK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>z wiersza 02</TD>
						<TD>osoby skierowane do pracy przez powiatowe urzędy pracy</TD>
						<TD align="center">12</TD>
						<TD align="right"><strong>(!)</strong></TD>
						<TD align="right"><strong>(!)</strong></TD>
					</TR>
					<TR>
						<TD colSpan="2"><STRONG>Zwolnieni</STRONG><EM> (pełnozatrudnieni)</EM> z 
								pracy<STRONG>&nbsp; w okresie </STRONG>od 1 I do 31 XII <STRONG>roku 
									sprawozdawczego </STRONG><EM>(suma wierszy 14+16+17+18+19+20+21+22)</EM></TD>
						<TD align="center">13</TD>
						<TD align="right"><ea:datalabel id="zwolnieni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="zwolnieniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby, które otrzymały urlopy wychowawcze</TD>
						<TD align="center">20</TD>
						<TD align="right"><ea:datalabel id="naurlop" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="naurlopK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby, które otrzymały urlopy bezpłatne</TD>
						<TD align="center">&nbsp;</TD>
						<TD align="right"><ea:datalabel id="nabezpłatny" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nabezpłatnyK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby, które otrzymały urlopy rehabilitacyjne</TD>
						<TD align="center">&nbsp;</TD>
						<TD align="right"><ea:datalabel id="narehab" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="narehabK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby powołane do dobycia służby wojskowej</TD>
						<TD align="center">&nbsp;</TD>
						<TD align="right"><ea:datalabel id="dowojska" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="dowojskaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="5"><ea:datalabel id="przyczyny" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="5"><b>Dodatkowe informacje - zbilansowanie działu 5 z działem 4 wiersz 03 (pracowników pełnozatrudnionych)</b></TD>
					</TR>
					<TR>
						<TD colSpan="2">Zatrudnieni, którzy w ciągu roku zmienili etat z niepełnego na pełny</TD>
						<TD align="center">23</TD>
						<TD align="right"><ea:datalabel id="niepełnyNaPełny" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="niepełnyNaPełnyK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Zatrudnieni, którzy w ciągu roku zmienili etat z pełnego na niepełny</TD>
						<TD align="center">24</TD>
						<TD align="right"><ea:datalabel id="pełnyNaNiepełny" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pełnyNaNiepełnyK" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="Pagebreak5" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 6. 
                Pracujący w miastach i gminach w głównym miejscu pracy (według faktycznego 
                miejsca pracy). 
                Stan w dniu 31 XII</font><br />
                
				<ea:datalabel id="miejsca" runat="server"></ea:datalabel>
		    </P>
			<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter>
		    <br />
		</form>
	</body>
</HTML>
